import http from 'http'
import {fileURLToPath} from 'url'
import fs from 'fs'
import path from 'path'

const filename=fileURLToPath(import.meta.url)
const __dirname=path.dirname(filename)
//js中可用的获取类似cjs中__dirname的方法

const server=http.createServer()

server.on('request',(req,res)=>{
    let url=req.url
    if(url=='/') url='/index.html'
    let filepath=path.join(__dirname,'./clock',url)
    fs.readFile(filepath,'utf-8',(err,content)=>{
        if(err){
            console.log('读取文件错误: '+err.message)
            res.end('404 Not Found')
            return
        }else{
            // res.setHeader('Content-Type','text/html; charset=utf-8')
            res.end(content)
        }
        
    })
})

try{
    server.listen('80',()=>{
        console.log('server running at http://127.0.0.1')
    })
}
catch(err){
    console.log('启动服务错误: '+err.message)
}