const fs=require('fs')
const path=require('path')

const regSytle=/<style>[\s\S]*<\/style>/ //匹配样式表的正则
// \s表示空字符  \S表示非空字符    *表示匹配任意次
const regScript=/<script>[\s\S]*<\/script>/ //匹配JaveScript的正则

const dataStr=fs.readFileSync(path.join(__dirname,'./index.html'),'utf-8',err=>{
    console.log('读取错误: '+err.message)
    return
})

if(!fs.existsSync('./clock')){
    fs.mkdirSync('./clock')
}

resolveStyle(dataStr)
resolveScript(dataStr)
resolveHtml(dataStr)

function resolveStyle(html){
    const style=regSytle.exec(html) //匹配
    const styleStr=style[0].replace('<style>','').replace('</style>','') //去掉标签
    fs.writeFileSync(path.join(__dirname,'./clock/index.css'),styleStr,'utf-8',err=>{ //写入
        console.log('写入css文件错误'+err.message)
        return
    })
}

function resolveScript(html){
    const script=regScript.exec(html)
    const scriptStr=script[0].replace('<script>','').replace('</script>','')
    fs.writeFileSync(path.join(__dirname,'./clock/index.js'),scriptStr,'utf-8',err=>{
        console.log('写入js文件错误'+err.message)
        return
    })
}

function resolveHtml(html){
    const newHtml=html.replace(regSytle,'<link rel="stylesheet" href="./index.css" />')
        .replace(regScript,'<script src="./index.js"></script>') //正则匹配并替换掉内嵌=>外联
    fs.writeFileSync(path.join(__dirname,'./clock/index.html'),newHtml,'utf-8',err=>{
        console.log('写入html文件错误'+err.message)
        return
    })
}